/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.integrator.VWCMAdminInfoPanel;
import filenet.vw.apps.taskman.integrator.VWCMAdminNode;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class VWCMAdminPropertyPanel
extends VWTaskPropertyPanel {
    private VWCMAdminNode m_node = null;
    private VWCMAdminInfoPanel m_cmAdminInfoPanel = null;

    public VWCMAdminPropertyPanel(VWCMAdminNode node) {
        this.setLayout(new BorderLayout());
        this.setDoubleBuffered(true);
        this.m_node = node;
        this.m_cmAdminInfoPanel = new VWCMAdminInfoPanel(this.m_node);
        this.m_cmAdminInfoPanel.addVWTaskPropertyChangedListener(this);
        this.add((Component)this.m_cmAdminInfoPanel, "Center");
        this.setValidationEnabled(true);
    }

    public void refresh() {
        try {
            if (!this.m_node.isDirty()) {
                this.resetProperties();
            }
        }
        catch (Exception e) {
            this.m_node.displayError(e);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                if (this.validateProperties()) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_node.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex, false);
        }
    }

    public void applyProperties() throws Exception {
        this.m_cmAdminInfoPanel.applyProperties();
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
    }

    public void resetProperties() throws Exception {
        this.m_cmAdminInfoPanel.resetProperties();
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    private boolean validateProperties() {
        try {
            this.m_cmAdminInfoPanel.validateTextFields();
        }
        catch (Exception e) {
            this.m_node.displayError(e);
            return false;
        }
        return true;
    }

    protected String getOptions() throws Exception {
        return this.m_cmAdminInfoPanel.getOptions();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   18 Sep 2006 22:02:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.0  $";
    }
}

